import pickle
import random
import numpy as np
from inspect import getmembers, isfunction
import itertools
from z3 import *
import pdfkit
import poetryrelations

n_lines = 10

output_dir = "pickles"

functions_list = [o for o in getmembers(poetryrelations) if isfunction(o[1]) if o[0] != "word"]
functions_name_list = [o[0] for o in functions_list if o[0] != "word"]


def color_format(color):
    return """
      <p style="color: """ + color + """; font-family: 'Liberation Sans',sans-serif">
        {}
      </p>
    """


poem_secs, poem_vecs = (list(pickle.load(open("pickles/poem_sec_vecs.pcl", "rb")).keys()), list(pickle.load(open("pickles/poem_sec_vecs.pcl", "rb")).values()))
poem_scores = list(pickle.load(open("pickles/poem_sec_scores.pcl", "rb")).values())
order = sorted(range(len(poem_scores)), key = lambda i: poem_scores[i], reverse=True)

prototype_ids = []
prototypes = []
adj_mats = []
simple_adjs = []
inds = []


set_param(timeout=60*1000)

for (z_ind, z) in enumerate(order[:2500]):
    
    
    tot_cost = Int("tot_cost")
    o = Optimize()

    poem_vec = poem_vecs[z]
    for i in range(n_lines):
        for (function_ind, function) in enumerate(functions_name_list):
            poem_vec[i,i,function_ind] = 1 if function != "endrhyme" else 5
    poem = poem_secs[z]

   
    refs = [BitVec("ref" + str(i), 5) for i in range(n_lines)]
    refs_used = [Bool("refs_used" + str(i)) for i in range(n_lines)]
    cost_refs = [Int("costref" + str(i)) for i in range(n_lines)]
    
    for i in range(n_lines):
        o.add(Implies(refs_used[i], refs[i] == i))
    o.add(Sum([If(refs_used[i],1, 0) for i in range(n_lines)]) >= 1)
    o.add(Sum([If(refs_used[i],1, 0) for i in range(n_lines)]) <= 6)
    ijs = list(itertools.product(list(range(n_lines)), list(range(n_lines))))

    for i in range(n_lines):
        o.add(BV2Int(refs[i]) < n_lines)
        o.add(BV2Int(refs[i]) >= 0)

        for j in range(n_lines):
            o.add(Implies(BV2Int(refs[i]) == j, refs_used[j]))
            o.add(Implies(BV2Int(refs[i]) == j, (cost_refs[i]) == np.sum(poem_vec[i][j])))
    b = Sum([If(And(refs_used[i], refs_used[j]), 10 + -3*np.sum(poem_vec[i][j]), 0)  for (i,j) in list(ijs) if i != j])
    c = Sum(cost_refs)
    q = Sum([If(refs[i] == refs[j], np.sum(poem_vec[i][j]) - 4, 0) for (i,j) in list(ijs) if i != j])
    try:
        h = o.maximize(q + c + b)
        o.check()
        o.upper(h)
        a = o.model()
        refs_used = [i for i in range(len(refs_used)) if a[refs_used[i]]]
    except:
        print("error")
        continue
    # Store sum of refs_used (number of reference measures used)
    
    refs = [int(str(a[i])) for i in refs]

    
    mat = np.zeros((n_lines + len(refs_used), len(refs_used) + n_lines, poem_vec.shape[2] + 2), dtype=np.bool) #adjacency matrix with each feature
    simple_mat = np.zeros((n_lines, len(refs_used)), dtype=np.bool) #adjacency matrix with yes/no edge
    
    
    for i in range(3, n_lines):
        for j in range(1, min(i,4)):
            if j == 1:
                mat[i,i - j, :] = np.array(list(poem_vec[i, i - j, :]) + [1,0])
            else:
                mat[i,i - j, :] = np.array(list(poem_vec[i, i - j, :]) + [0,0])


    for i in range(len(poem)):
        j = refs[i] #j is ref measure that i is similar to
        j_ind = refs_used.index(refs[i]) #index of reference measure
        simple_mat[i,j_ind] = 1
        vec = poem_vec[i][j]
        #print("VEC", vec)
        for k in range(len(vec)):
            if vec[k]:
                mat[i, j_ind + len(poem), k] = 1
        #print("MAT", mat[i, j_ind + len(poem)])

    prototype_ids.append((refs_used))
    prototypes.append([poem[q] for q in refs_used])
    print(refs)
    adj_mats.append(mat)
    simple_adjs.append(simple_mat)
    inds.append(z)
    #Simple_mat is TRUE for the reference measure that is similar to each measure

    pickle.dump(inds, open(output_dir + "/inds" + str(n_lines) +".pcl", "wb"))
    pickle.dump(prototypes, open(output_dir + "/prototypes" + str(n_lines) + ".pcl", "wb"))
    pickle.dump(prototype_ids, open(output_dir + "/prototype-ids" + str(n_lines) + ".pcl", "wb"))
    pickle.dump(adj_mats, open(output_dir + "/adj_mats" + str(n_lines) + ".pcl", "wb"))
    pickle.dump(simple_adjs, open(output_dir + "/simple_mats" + str(n_lines) + ".pcl", "wb"))

    colors = ["red", "green", "blue", "brown", "pink", "purple"]
    string = ""
    for (q, line) in enumerate(poem):
        string += color_format(colors[refs_used.index(refs[q])]).format(line)

